 /* 'mrTimer.cpp' */

 /* Komplementarny plik nagwka */
#include "mrTimer.h"

 /* Konstruktor domylny */
mrTimer::mrTimer (void)
{
  /* Pobierz czstotliwo zegara sprztowego i jego biecy stan */
 QueryPerformanceFrequency (&m_iFrequency);
 QueryPerformanceCounter (&m_iLastQuery);
}

 /* Destruktor domylny */
mrTimer::~mrTimer (void)
{
 m_iFrequency.QuadPart = 0;
 m_iLastQuery.QuadPart = 0;
}

 /* Aktualizuj zegar */
void mrTimer::Update (void)
{
 LARGE_INTEGER  kTempTimer;
 time_t         iTempTimeDate;

  /* Pobierz biecy stan zegara i oblicz rnic */
 QueryPerformanceCounter (&kTempTimer);
 m_iDelta.QuadPart = kTempTimer.QuadPart - m_iLastQuery.QuadPart;

  /* Zachowaj biecy stan zegara */
 m_iLastQuery.QuadPart = kTempTimer.QuadPart;

  /* Pobierz biecy czas i dat */
 time (&iTempTimeDate);
 m_pkTime = localtime (&iTempTimeDate);
}

 /* Pobierz zmian czasu od ostaniej aktualizacji */
mrReal32 mrTimer::GetDelta (void)
{
  /* Zamie na liczb zmiennoprzecinkow i oblicz zmian w sekundach */
 return (mrReal32)(m_iDelta.QuadPart) / 
        (mrReal32)(m_iFrequency.QuadPart);
}

 /* Pobierz sekundy zegara systemowego */
mrUInt32 mrTimer::GetSeconds (void)
{
 return m_pkTime->tm_sec;
}

 /* Pobierz minuty zegara systemowego */
mrUInt32 mrTimer::GetMinutes (void)
{
 return m_pkTime->tm_min;
}

 /* Pobierz godziny zegara systemowego */
mrUInt32 mrTimer::GetHours (void)
{
 return m_pkTime->tm_hour;
}

 /* Pobierz dzie z zegara systemowego */
mrUInt32 mrTimer::GetDay (void)
{
 return m_pkTime->tm_mday;
}

 /* Pobierz miesic z zegara systemowego */
mrUInt32 mrTimer::GetMonth (void)
{
 return m_pkTime->tm_mon;
}

 /* Pobierz rok z zegara systemowego */
mrUInt32 mrTimer::GetYear (void)
{
 return m_pkTime->tm_year;
}